package com.atlassian.sal.api.project;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;

/**
 * Interface to managing and getting information about "projects".  A project may represent different things depending
 * on the application, for example, in Confluence, it is a space, in Bamboo, a build plan, and in JIRA, it is a
 * project.
 *
 * @since 2.0
 */
public interface ProjectManager
{
    /**
     * Get all project keys. This should ignore any permission checking.
     *
     * @return All the project keys or an empty collection if it cannot be provided by the current application. Empty collection if none found.
     */
    Collection<String> getAllProjectKeys();

    /**
     * Retrieve basic details about a project, given the project Key.
     * <em>Will</em> check permissions.
     * @param key of the project
     * @return Null returned if not found or you do not have permission to view it.
     * @since 2.8
     */
    @Nullable
    ProjectEntity getProjectByKey(@Nonnull String key);
}
