package com.atlassian.sal.api.project;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.net.URI;

/**
 * Represents a common view of a Project. A project may represent different things depending on the application, for
 * example, in Confluence, it is a space, in Bamboo, a build plan, and in JIRA, it is a project.
 */
public interface ProjectEntity
{
    /**
     * Key of the project. Used for searching.  Must be unique.
     */
    @Nonnull
    String getKey();

    /**
     * Display Name of the Project.
     */
    @Nonnull
    String getName();

    /**
     * Description of the project, if applicable.
     */
    @Nullable
    String getDescription();

    /**
     * URI to navigate to the project.
     * The URI will either be relative to the application's base URI, or absolute.
     */
    @Nonnull
    URI getUri();

    /**
     * Returns a URI for the user's profile picture. The returned URI will point
     * to the largest possible unscaled image (within reason!) of the project's avatar that the application
     * can provide
     *
     * The URI will either be relative to the application's base URI, or absolute.
     *
     * @return a URI pointing to an image of the project's avatar, or {@code null}
     * if a avatar was not provided, the application does not support
     * project avatars.
     */
    @Nullable
    URI getAvatarUri();
}



