/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.events;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SessionDestroyedEvent {
    private final String sessionId;
    private final String userName;

    private SessionDestroyedEvent(String sessionId, String userName) {
        this.sessionId = sessionId;
        this.userName = userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public static class Builder {
        private String sessionId;
        private String userName;

        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            if (sessionId == null) {
                throw new NullPointerException("Session ID must be supplied");
            }
            this.sessionId = sessionId;
            return this;
        }

        public Builder userName(@Nullable String userName) {
            this.userName = userName;
            return this;
        }

        public SessionDestroyedEvent build() {
            if (this.sessionId == null) {
                throw new NullPointerException("Session ID must be supplied");
            }
            return new SessionDestroyedEvent(this.sessionId, this.userName);
        }
    }
}

