package com.atlassian.sal.api.features;

import com.google.common.base.Predicate;

import javax.annotation.Nullable;

/**
 * @since 2.10
 */
public class FeatureKeyClassifierPredicate implements Predicate<FeatureKeyClassifier>
{
    private final FeatureKeyClassifier classifier;

    public FeatureKeyClassifierPredicate(final FeatureKeyClassifier classifier)
    {
        this.classifier = classifier;
    }

    public static FeatureKeyClassifierPredicate filterBy(final FeatureKeyClassifier classifier)
    {
        return new FeatureKeyClassifierPredicate(classifier);
    }

    @Override
    public boolean apply(@Nullable final FeatureKeyClassifier input)
    {
        return input != null && input == classifier;
    }
}
