package com.atlassian.sal.api.executor;

/**
 * Manager for retrieving and storing a single object which represents all thread local state
 */
public interface ThreadLocalContextManager<C extends ThreadLocalContext>
{
    /**
     * Get the thread local context of the current thread
     *
     * @return The thread local context
     */
    C getThreadLocalContext();

    /**
     * Set the thread local context on the current thread
     *
     * @param context The context to set
     */
    void setThreadLocalContext(C context);

    /**
     * Clear the thread local context on the current thread
     */
    void clearThreadLocalContext();

}
