/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http;

import com.atlassian.sal.api.http.Authenticator;
import com.atlassian.sal.api.http.HttpParameters;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    private String url = null;
    private int maximumSize = 0;
    private long maximumCacheAgeInMillis = 0L;
    private Authenticator authenticator = null;
    private HttpParameters httpParameters = null;
    private HttpMethodType methodType = HttpMethodType.GET;
    private Map<String, String> requestParams = new HashMap<String, String>();
    private String requestBody;
    private String requestContentType = "application/octet-stream";

    public String getUrl() {
        return this.url;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public long getMaximumCacheAgeInMillis() {
        return this.maximumCacheAgeInMillis;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public HttpParameters getHttpParameters() {
        return this.httpParameters;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMaximumCacheAgeInMillis(long maximumCacheAgeInMillis) {
        this.maximumCacheAgeInMillis = maximumCacheAgeInMillis;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setHttpParameters(HttpParameters httpParameters) {
        this.httpParameters = httpParameters;
    }

    public HttpMethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(HttpMethodType httpMethodType) {
        this.methodType = httpMethodType;
    }

    public void setRequestBody(String data) {
        this.requestBody = data;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestContentType(String contentType) {
        this.requestContentType = contentType;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void addPostParameter(String key, String value) {
        if (!this.methodType.equals((Object)HttpMethodType.POST)) {
            throw new IllegalStateException("Method must be POST to add post parameters. Method is: " + (Object)((Object)this.methodType));
        }
        this.requestParams.put(key, value);
    }

    public Map<String, String> getPostParams() {
        return Collections.unmodifiableMap(this.requestParams);
    }

    public String toString() {
        return (Object)((Object)this.methodType) + " " + this.url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethodType {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        TRACE,
        OPTIONS;

    }
}

