/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http;

import java.io.Serializable;

public final class HttpParameters
implements Serializable {
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private final int connectionTimeout;
    private final int socketTimeout;
    private final boolean enabled;

    public HttpParameters() {
        this.connectionTimeout = 10000;
        this.socketTimeout = 10000;
        this.enabled = true;
    }

    public HttpParameters(int connectionTimeout, int socketTimeout, boolean enabled) {
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.enabled = enabled;
    }

    public final int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final int getSocketTimeout() {
        return this.socketTimeout;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.connectionTimeout);
        sb.append('\n');
        sb.append(this.socketTimeout);
        sb.append('\n');
        sb.append(this.enabled);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof HttpParameters)) {
            return false;
        }
        HttpParameters other = (HttpParameters)o;
        return other.enabled == this.enabled && other.connectionTimeout == this.connectionTimeout && other.socketTimeout == this.socketTimeout;
    }

    public int hashCode() {
        int result = this.connectionTimeout;
        result = 31 * result + this.socketTimeout;
        result = 37 * result + (this.enabled ? 1 : 0);
        return result;
    }
}

