/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class ObjectiveCFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = ObjectiveCFormatter.individualWords(new String[]{"@autoreleasepool", "@catch", "@class", "@compatibility_alias", "@defs", "@dynamic", "@encode", "@end", "@finally", "@implementation", "@interface", "@optional", "@package", "@private", "@property", "@protected", "@protocol", "@public", "@required", "@selector", "@synchronized", "@synthesize", "@throw", "@try", "IMP", "NO", "NULL", "Protocol", "YES", "atomic", "auto", "break", "bycopy", "byref", "case", "const", "continue", "default", "do", "else", "enum", "extern", "for", "goto", "[^#]if", "[^#]import", "in", "inline", "inout", "nil", "nonatomic", "oneway", "out", "register", "restrict", "retain", "return", "self", "sizeof", "static", "struct", "super", "switch", "typedef", "union", "volatile", "while", "__weak"});
    private static final String ATS = "(@autoreleasepool|@catch|@class|@compatibility_alias|@defs|@dynamic|@encode|@end|@finally|@implementation|@interface|@optional|@package|@private|@property|@protected|@protocol|@public|@required|@selector@synchronized|@synthesize|@throw|@try)";
    private static final String OBJECTS = ObjectiveCFormatter.individualWords(new String[]{"BOOL", "char", "Class", "double", "float", "IBAction", "IBOutlet", "id", "IMP", "instancetype", "int", "long", "SEL", "short", "signed", "unsigned", "void", "[A-Z][A-Z][a-zA-Z0-9]+", "__Bool", "__Complex", "__Imaginary", "__block"});
    private static final String ANGLED = "(\\&lt;)(.+?)(?<!(\\&gt;))(\\&gt;)";
    private static final String AT_DQUOTES = "@(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)";
    private static final String PREPROCESSOR_DIRECTIVES = "#(.*?)($|\r?\n)";
    private static final String PREPROCESSOR_REPLACEMENT = "<span class=\"code-macro\">$0</span>";
    private static final String AT_DQUOTES_REPLACEMENT = "<span class=\"code-quote-red\">$0</span>";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"objc"};

    public ObjectiveCFormatter() {
        this.addReplacement(AT_DQUOTES, AT_DQUOTES_REPLACEMENT);
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement(ANGLED, "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement(PREPROCESSOR_DIRECTIVES, PREPROCESSOR_REPLACEMENT);
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(ATS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

