/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.basic.AbstractPanelMacro;
import com.atlassian.renderer.v2.macro.code.SimpleSourceCodeFormatterRepository;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatter;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatterRepository;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CodeMacro
extends AbstractPanelMacro {
    private static final String DEFAULT_LANG = "java";
    private SourceCodeFormatterRepository codeFormatterRepository;

    public CodeMacro(V2SubRenderer subRenderer, List<SourceCodeFormatter> formatters) {
        this.setCodeFormatterRepository(new SimpleSourceCodeFormatterRepository(formatters));
        this.setSubRenderer(subRenderer);
    }

    public void setCodeFormatterRepository(SourceCodeFormatterRepository codeFormatterRepository) {
        this.codeFormatterRepository = codeFormatterRepository;
    }

    public CodeMacro() {
    }

    @Override
    public boolean suppressMacroRenderingDuringWysiwyg() {
        return false;
    }

    @Override
    protected String getPanelCSSClass() {
        return "code panel";
    }

    @Override
    protected String getPanelHeaderCSSClass() {
        return "codeHeader panelHeader";
    }

    @Override
    protected String getPanelContentCSSClass() {
        return "codeContent panelContent";
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.allow(128L);
    }

    @Override
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String language = this.getLanguage(parameters).toLowerCase();
        SourceCodeFormatter formatter = this.getFormatter(language);
        String preamble = "";
        String classAttr = "";
        if (formatter == null) {
            String availableLanguages = this.codeFormatterRepository.getAvailableLanguages().stream().map(Object::toString).collect(Collectors.joining(", "));
            preamble = RenderUtils.blockError("Unable to find source-code formatter for language: " + language + ".", "Available languages are: " + availableLanguages);
            formatter = this.getFormatter(DEFAULT_LANG);
        } else {
            classAttr = " class=\"code-" + HtmlEscaper.escapeAll(language, false) + "\"";
        }
        String code = body;
        if (code.startsWith("\n")) {
            code = code.substring(1);
        }
        if (code.endsWith("\n")) {
            code = code.substring(0, code.length());
        }
        String formatted = renderContext.getUnicodeEscapingTool().escapeBidiCharacters(formatter.format(code, language));
        return super.execute(parameters, preamble + "<pre" + classAttr + ">" + formatted + "</pre>", renderContext);
    }

    @Override
    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    private SourceCodeFormatter getFormatter(String language) {
        return this.codeFormatterRepository.getSourceCodeFormatter(language);
    }

    private String getLanguage(Map parameters) {
        String lang = (String)parameters.get("lang");
        if (StringUtils.isEmpty((CharSequence)lang)) {
            lang = (String)parameters.get("0");
        }
        if (StringUtils.isEmpty((CharSequence)lang)) {
            lang = DEFAULT_LANG;
        }
        return lang;
    }
}

