/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.util;

import com.atlassian.renderer.util.UnicodeEscapingTool;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;

public class DefaultUnicodeEscapingTool
implements UnicodeEscapingTool {
    private static final Set<Integer> DEFAULT_BIDI_CHARACTERS = new HashSet<Integer>(Arrays.asList(8234, 8235, 8236, 8237, 8238, 8294, 8295, 8296, 8297));
    private static final String ESCAPED_BIDI_PREFIX = "<span contenteditable=\"false\" class=\"bidi-unicode\" title=\"%s\" data-bidi-character-code=\"";
    private static final String ESCAPED_BIDI_MIDDLE_PART = "\">";
    private static final String ESCAPED_BIDI_SUFFIX = "<!--Bidi char--></span>";
    private final Set<Integer> bidiUnicodeCharacters;
    private final Supplier<String> warningMessageSupplier;

    public DefaultUnicodeEscapingTool(Supplier<String> warningMessageSupplier) {
        this(Collections.emptySet(), warningMessageSupplier);
    }

    public DefaultUnicodeEscapingTool(Set<Integer> bidiUnicodeCharacters, Supplier<String> warningMessageSupplier) {
        this.bidiUnicodeCharacters = new HashSet<Integer>(bidiUnicodeCharacters);
        this.bidiUnicodeCharacters.addAll(DEFAULT_BIDI_CHARACTERS);
        this.warningMessageSupplier = warningMessageSupplier;
    }

    @Override
    public String escapeBidiCharacters(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        String prefix = String.format(ESCAPED_BIDI_PREFIX, this.warningMessageSupplier.get());
        text.codePoints().forEach(character -> {
            if (this.bidiUnicodeCharacters.contains(character)) {
                builder.append(prefix);
                builder.append(Integer.toHexString(character).toUpperCase(Locale.ROOT));
                builder.append(ESCAPED_BIDI_MIDDLE_PART);
                builder.append(Character.toChars(character));
                builder.append(ESCAPED_BIDI_SUFFIX);
            } else {
                builder.append(Character.toChars(character));
            }
        });
        return builder.toString();
    }
}

