/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.util.UnicodeEscapingTool;
import com.atlassian.renderer.v2.Renderer;
import com.atlassian.renderer.v2.TokenEscapingV2Renderer;
import com.opensymphony.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2RendererFacade
implements WikiStyleRenderer {
    private static final Logger log = LoggerFactory.getLogger(V2RendererFacade.class);
    private RendererConfiguration rendererConfiguration;
    private LinkRenderer defaultLinkRenderer;
    private EmbeddedResourceRenderer defaultEmbeddedRenderer;
    private TokenEscapingV2Renderer renderer;
    private boolean escapeInternalTokens = true;
    private UnicodeEscapingTool defaultUnicodeEscapingTool;

    public V2RendererFacade() {
    }

    public V2RendererFacade(RendererConfiguration rendererConfiguration, LinkRenderer defaultLinkRenderer, EmbeddedResourceRenderer defaultEmbeddedRenderer, Renderer renderer, UnicodeEscapingTool defaultUnicodeEscapingTool, boolean escapeInternalTokens) {
        this.rendererConfiguration = rendererConfiguration;
        this.defaultLinkRenderer = defaultLinkRenderer;
        this.defaultEmbeddedRenderer = defaultEmbeddedRenderer;
        this.defaultUnicodeEscapingTool = defaultUnicodeEscapingTool;
        this.renderer = new TokenEscapingV2Renderer(renderer, escapeInternalTokens);
        this.escapeInternalTokens = escapeInternalTokens;
        this.logSanitizer(escapeInternalTokens);
    }

    private void logSanitizer(boolean escapeInternalTokens) {
        if (escapeInternalTokens) {
            log.debug("Enabled wiki markup sanitizer");
        } else {
            log.info("Disabled wiki markup sanitizer");
        }
    }

    public void setRendererConfiguration(RendererConfiguration rendererConfiguration) {
        this.rendererConfiguration = rendererConfiguration;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = new TokenEscapingV2Renderer(renderer, this.escapeInternalTokens);
    }

    public void setEscapeInternalTokens(boolean escapeInternalTokens) {
        this.escapeInternalTokens = escapeInternalTokens;
        if (this.renderer != null) {
            this.renderer.setEscapeInternalTokens(escapeInternalTokens);
        }
        this.logSanitizer(escapeInternalTokens);
    }

    public boolean isEscapeInternalTokensEnabled() {
        return this.escapeInternalTokens;
    }

    @Override
    public String convertWikiToXHtml(RenderContext context, String wiki) {
        if (!TextUtils.stringSet((String)wiki)) {
            return "";
        }
        if (context.getRenderMode() != null && context.getRenderMode().renderNothing()) {
            return wiki;
        }
        this.initializeContext(context);
        return this.renderer.render(wiki, context);
    }

    public String convertWikiToText(RenderContext context, String wiki) {
        if (!TextUtils.stringSet((String)wiki)) {
            return "";
        }
        if (context.getRenderMode().renderNothing()) {
            return wiki;
        }
        this.initializeContext(context);
        return this.renderer.renderAsText(wiki, context);
    }

    public void setDefaultLinkRenderer(LinkRenderer linkRenderer) {
        this.defaultLinkRenderer = linkRenderer;
    }

    public void setDefaultEmbeddedRenderer(EmbeddedResourceRenderer embeddedRenderer) {
        this.defaultEmbeddedRenderer = embeddedRenderer;
    }

    public void setDefaultUnicodeEscapingTool(UnicodeEscapingTool defaultUnicodeEscapingTool) {
        this.defaultUnicodeEscapingTool = defaultUnicodeEscapingTool;
    }

    private void initializeContext(RenderContext context) {
        if (context.getSiteRoot() == null) {
            context.setSiteRoot(this.rendererConfiguration.getWebAppContextPath());
        }
        if (context.getImagePath() == null) {
            context.setImagePath(context.getSiteRoot() + "/images");
        }
        if (context.getLinkRenderer() == null) {
            context.setLinkRenderer(this.defaultLinkRenderer);
        }
        if (context.getEmbeddedResourceRenderer() == null) {
            context.setEmbeddedResourceRenderer(this.defaultEmbeddedRenderer);
        }
        if (context.getCharacterEncoding() == null) {
            context.setCharacterEncoding(this.rendererConfiguration.getCharacterEncoding());
        }
        if (context.getSetUnicodeEscapingTool() == null) {
            context.setUnicodeEscapingTool(this.defaultUnicodeEscapingTool);
        }
    }
}

