package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import com.atlassian.renderer.wysiwyg.Styles;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class FormatConverter implements Converter {
    public static FormatConverter INSTANCE = new FormatConverter();
    private static final Map<String, String> STYLE_MAPPINGS;
    /**
     * A collection of all the style node types recognised by the FormatConverter.  All types are lower-case.
     */
    static final Collection<String> STYLE_NODE_TYPES;

    static {
        Map<String, String> temp = new HashMap<String, String>();
        temp.put("b", Styles.BOLD);
        temp.put("strong", Styles.BOLD);
        temp.put("i", Styles.ITALIC);
        temp.put("em", Styles.ITALIC);
        temp.put("del", Styles.STRIKETHROUGH);
        temp.put("strike", Styles.STRIKETHROUGH);
        temp.put("ins", Styles.UNDERLINE);
        temp.put("u", Styles.UNDERLINE);
        temp.put("sub", Styles.SUBSCRIPT);
        temp.put("sup", Styles.SUPERSCRIPT);
        temp.put("cite", Styles.CITE);
        temp.put("tt", Styles.MONOSPACE);
        STYLE_MAPPINGS = Collections.unmodifiableMap(temp);
        STYLE_NODE_TYPES = Collections.unmodifiableSet(STYLE_MAPPINGS.keySet());
    }

    private FormatConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return STYLE_MAPPINGS.keySet().contains(nodeContext.getNode().getNodeName().toLowerCase());
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        String style = STYLE_MAPPINGS.get(nodeContext.getNode().getNodeName().toLowerCase());

        return wysiwygConverter.getSeparator("text", nodeContext) +
                wysiwygConverter.convertChildren(new NodeContext.Builder(nodeContext).addStyle(style).ignoreText(false).previousSibling(null).build());
    }
}
