package com.atlassian.renderer.wysiwyg;

import com.atlassian.renderer.RenderContext;
import org.w3c.dom.Node;

public interface WysiwygConverter {

    /**
     * @deprecated As of release 4.1, use {@link com.atlassian.renderer.util.NodeUtil#getAttribute(org.w3c.dom.Node, String)}.
     */
    String getAttribute(Node node, String name);

    /**
     * @deprecated Since 5.0. Use {@link #convertChildren(NodeContext)} instead.
     */
    String convertChildren(Node node, Styles styles, ListContext listContext, boolean inTable, boolean inListItem, boolean ignoreText, boolean escapeWikiMarkup, Node overridePreviousSibling);

    /**
     * Converts the children nodes of the given node in the node context to wiki markup.
     *
     * @return the wiki markup of the children nodes
     */
    String convertChildren(NodeContext nodeContext);

    /**
     * Converts the node in the node context to wiki markup.
     *
     * @return the wiki markup of the node
     */
    String convertNode(NodeContext nodeContext);

    String convertXHtmlToWikiMarkup(String xhtml);

    String convertWikiMarkupToXHtml(RenderContext ctx, String wikiMarkup);

    String getMacroInfoHtml(RenderContext context, String name, int xOffset, int yOffset);

    String getSep(Node previous, String next, boolean inTable, boolean inList);
}
