package com.atlassian.renderer.v2.macro.code.formatter;

public class ScalaFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "abstract", "case", "catch", CLASS, "def", "do", "else", "extends", "false", "final",
            "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null",
            "object", "override", "package", "private", "protected", "return", "sealed", "super",
            "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Any", "AnyRef", "AnyVal", "boolean", "byte", "char",
            "double", "float", "int", "long", "short",
            "Nothing", "Null"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"scala"};

    public ScalaFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}