package com.atlassian.renderer.v2.macro.code.formatter;

public class RubyFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "__ENCODING__", "__LINE__", "__FILE__", "BEGIN", "END", "alias", "and", "begin", "break",
            "case", CLASS, "def", "defined\\??", "do", "else", "elsif", "end", "ensure", "false",
            "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return",
            "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield",
            "=begin", "=end"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Array", "Bignum", "FalseClass", "Fixnum", "Float", "Hash", "Integer", "NilClass", "Numeric",
            "Range", "String", "Symbol", "TrueClass"
    });

    private static final String ATS = "(@[A-Za-z0-9]+)\\s{1}";

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"ruby"};

    public RubyFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(ATS, OBJECT_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}