package com.atlassian.renderer.v2.macro.code.formatter;

public class PythonFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "False", "None", "True", "and", "as", "assert", "break", CLASS, "continue", "def", "del",
            "elif", "else", "except", "finally", "for", "from", "global", "if", "import", "in", "is",
            "lambda", "nonlocal", "not", "or", "pass", "raise", "return", "self", "super", "try",
            "while", "with", "yield"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "ArithmeticError", "AssertionError", "AttributeError", "BaseException", "BufferError",
            "BytesWarning", "DeprecationWarning", "EOFError", "Ellipsis", "EnvironmentError",
            "Exception", "False", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError",
            "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError",
            "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "None", "NotImplemented",
            "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning",
            "ReferenceError", "RuntimeError", "RuntimeWarning", "StandardError", "StopIteration",
            "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "True",
            "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError",
            "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError",
            "Warning", "ZeroDivisionError", "__debug__", "__dict__", "__doc__", "__import__", "__name__",
            "__package__", "abs", "all", "any", "apply", "basestring", "bin", "bool", "buffer",
            "bytearray", "bytes", "callable", "chr", "classmethod", "cmp", "coerce", "compile",
            "complex", "copyright", "credits", "delattr", "dict", "dir", "divmod", "enumerate",
            "eval", "execfile", "exit", "file", "filter", "float", "format", "frozenset", "getattr",
            "globals", "hasattr", "hash", "help", "hex", "id", "input", "int", "intern", "isinstance",
            "issubclass", "iter", "len", "license", "list", "locals", "long", "map", "max", "memoryview",
            "min", "next", "object", "oct", "open", "ord", "pow", "print", "property", "quit", "range",
            "raw_input", "reduce", "reload", "repr", "reversed", "round", "set", "setattr", "slice",
            "sorted", "staticmethod", "str", "sum", "super", "tuple", "type", "unichr", "unicode",
            "vars", "xrange", "zip"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"python"};

    public PythonFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}