package com.atlassian.renderer.v2.macro.code.formatter;

public class PerlFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            ":bytes", ":crlf", ":mmap", ":perlio", ":pop", ":raw", ":stdio", ":unix", ":utf8", ":win32",
            "@F", "ACCUMULATOR", "ARG", "BASETIME", "CHILD_ERROR", "CHILD_ERROR_NATIVE", "CLEAR",
            "CLOSE", "COMPILING", "CORE", "DATA", "DEBUGGING", "DELETE", "EFFECTIVE_GROUP_ID",
            "EFFECTIVE_USER_ID", "EGID", "ENCODING", "ENV", "ERRNO", "EUID", "EVAL_ERROR",
            "EXCEPTIONS_BEING_CAUGHT", "EXECUTABLE_NAME", "EXISTS", "EXTEND", "EXTENDED_OS_ERROR",
            "FETCH", "FETCHSIZE", "FIRSTKEY", "FORMAT_FORMFEED", "FORMAT_LINES_LEFT",
            "FORMAT_LINES_PER_PAGE", "FORMAT_LINE_BREAK_CHARACTERS", "FORMAT_NAME",
            "FORMAT_PAGE_NUMBER", "FORMAT_TOP_NAME", "GETC", "GID", "GetOptions", "HOME", "INC",
            "INPLACE_EDIT", "INPUT_LINE_NUMBER", "INPUT_RECORD_SEPARATOR", "ISA", "LAST_MATCH_END",
            "LAST_MATCH_START", "LAST_PAREN_MATCH", "LAST_REGEXP_CODE_RESULT", "LAST_SUBMATCH_RESULT",
            "LIST_SEPARATOR", "LOGDIR", "MATCH", "MULTILINE_MATCHING", "NEXTKEY", "NR", "OFS", "OPEN",
            "ORS", "OSNAME", "OS_ERROR", "OUTPUT_AUTOFLUSH", "OUTPUT_FIELD_SEPARATOR",
            "OUTPUT_RECORD_SEPARATOR", "PATH", "PERL5DB", "PERL5DB_THREADED", "PERL5LIB", "PERL5OPT",
            "PERL5SHELL", "PERLDB", "PERLIO", "PERLIO_DEBUG", "PERLLIB", "PERL_ALLOW_NON_IFS_LSP",
            "PERL_DEBUG_MSTATS", "PERL_DESTRUCT_LEVEL", "PERL_DL_NONLAZY", "PERL_ENCODING",
            "PERL_HASH_SEED", "PERL_HASH_SEED_DEBUG", "PERL_ROOT", "PERL_SIGNALS", "PERL_UNICODE",
            "PERL_VERSION", "PID", "POP", "POSTMATCH", "PREMATCH", "PRINT", "PRINTF", "PROCESS_ID",
            "PROGRAM_NAME", "PUSH", "READ", "READLINE", "REAL_GROUP_ID", "REAL_USER_ID",
            "RE_DEBUG_FLAGS", "RE_TRIE_MAXBUF", "RS", "SHIFT", "SIG", "SKIP:", "SPLICE", "STORE",
            "STORESIZE", "SUBSCRIPT_SEPARATOR", "SUBSEP", "SYSTEM_FD_MAX", "TAINT", "TIEARRAY",
            "TIEHANDLE", "TIEHASH", "TIESCALAR", "TODO:", "UID", "UNICODE", "UNSHIFT", "UNTIE",
            "UTF8CACHE", "UTF8LOCALE", "VERSION", "WARNING", "WARNING_BITS", "WIN32_SLOPPY_STAT",
            "WRITE", "_", "__DATA__", "__DIE__", "__END__", "__FILE__", "__LINE__", "__PACKAGE__",
            "__WARN__", "a", "abs2rel", "and", "b", "back", "basename", "begin", "builder", "can",
            "can_ok", "canonpath", "carp", "case_tolerant", "catdir", "catfile", "catpath", "cluck",
            "cmp", "cmp_ok", "confess", "continue", "copy", "cp", "croak", "curdir", "cut", "devnull",
            "diag", "dirname", "do", "else", "elsif", "end", "eq", "eq_array", "eq_hash", "eq_set",
            "exp", "fail", "file_name_is_absolute", "fileparse", "fileparse_set_fstype", "find",
            "finddepth", "for", "foreach", "freeze", "ge", "head1", "head2", "head3", "head4",
            "if", "is", "is_deeply", "isa", "isa_ok", "isnt", "item", "le", "like", "lock", "longmess",
            "m", "mkdtemp", "mkpath", "mkstemp", "mkstemps", "mktemp", "move", "mv", "ne", "no",
            "no_upwards", "ok", "or", "over", "package", "pass", "path", "plan", "pod", "q", "qq",
            "qr", "qw", "qx", "rel2abs", "require_ok", "rmscopy", "rmtree", "rootdir", "s", "safe_level",
            "shortmess", "skip", "splitdir", "splitpath", "sub", "tempdir", "tempfile", "thaw", "tmpdir",
            "tmpfile", "tmpnam", "todo_skip", "tr", "unless", "unlike", "unlink0", "until", "updir",
            "use_ok", "while", "xor", "y"
    });

    private static final String ANGLED = "(\\&lt;)(.+?)(?<!(\\&gt;))(\\&gt;)";
    private static final String SCALARS = "(\\$[A-Za-z0-9]+)\\b";
    private static final String ARRAYS = "(@[A-Za-z0-9]+)\\b";
    private static final String DICTS = "(%[A-Za-z0-9]+)\\b";

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"perl"};

    public PerlFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(ANGLED, QUOTES_REPLACEMENT_RED);
        addReplacement(SCALARS, OBJECT_REPLACEMENT);
        addReplacement(ARRAYS, OBJECT_REPLACEMENT);
        addReplacement(DICTS, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}