package com.atlassian.renderer.v2.macro.code.formatter;

public class JavaScriptFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "abstract", "boolean", "break", "byte", "case", "catch", "char", "const", "continue",
            "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends",
            "false", "final", "finally", "float", "for", "function", "goto", "if", "implements",
            "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null",
            "package", "private", "protected", "prototype", "public", "return", "short", "static",
            "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try",
            "typeof", "var", "void", "while", "with"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler",
            "Double", "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable",
            "Runtime", "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread",
            "ThreadGroup", "Void", "boolean", "char", "byte", "short", "int", "long", "float", "double"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"javascript", "js", "json"};

    public JavaScriptFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(BQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}