package com.atlassian.renderer.v2.macro.code.formatter;

public class CssFormatter extends AbstractFormatter {

    // Sorted by length so that the longest possible match is found first
    private static final String KEYWORDS = individualWords(new String[]{
            "transition-timing-function", "border-bottom-right-radius", "border-bottom-left-radius",
            "animation-timing-function", "animation-iteration-count", "text-underline-position",
            "font-variant-east-asian", "font-variant-alternates", "border-top-right-radius",
            "font-variant-ligatures", "font-language-override", "border-top-left-radius",
            "text-decoration-style", "text-decoration-color", "font-variant-position",
            "font-feature-settings", "background-blend-mode", "background-attachment",
            "text-decoration-line", "text-combine-upright", "text-combine-upright",
            "font-variant-numeric", "box-decoration-break", "animation-play-state",
            "transition-property", "transition-duration", "list-style-position", "hanging-punctuation",
            "border-image-source", "border-image-repeat", "border-image-outset", "border-bottom-width",
            "border-bottom-style", "border-bottom-color", "background-position", "backface-visibility",
            "animation-fill-mode", "animation-direction", "perspective-origin", "marquee-play-count",
            "border-right-width", "border-right-style", "border-right-color", "border-image-width",
            "border-image-slice", "animation-duration", "voice-pitch-range", "page-break-inside",
            "page-break-before", "marquee-direction", "image-orientation", "font-variant-caps",
            "counter-increment", "column-rule-width", "column-rule-style", "column-rule-color",
            "border-left-width", "border-left-style", "border-left-color", "background-repeat",
            "background-origin", "transition-delay", "transform-origin", "text-orientation",
            "page-break-after", "list-style-image", "image-resolution", "font-size-adjust",
            "border-top-width", "border-top-style", "border-top-color", "background-image",
            "background-color", "transform-style", "text-decoration", "text-align-last",
            "object-position", "list-style-type", "justify-content", "image-rendering",
            "border-collapse", "background-size", "background-clip", "animation-delay",
            "voice-duration", "vertical-align", "text-transform", "padding-bottom", "outline-offset",
            "letter-spacing", "font-synthesis", "flex-direction", "border-spacing", "animation-name",
            "voice-balance", "text-overflow", "padding-right", "overflow-wrap", "outline-width",
            "outline-style", "outline-color", "marquee-style", "marquee-speed", "margin-bottom",
            "counter-reset", "border-radius", "border-bottom", "align-content", "writing-mode",
            "word-spacing", "voice-volume", "voice-stress", "unicode-bidi", "text-justify",
            "table-layout", "padding-left", "margin-right", "font-variant", "font-stretch",
            "font-kerning", "column-width", "column-count", "caption-side", "break-inside",
            "break-before", "border-width", "border-style", "border-right", "border-image",
            "border-color", "white-space", "voice-pitch", "user-select", "text-shadow", "text-indent",
            "rest-before", "perspective", "padding-top", "mark-before", "margin-left", "line-height",
            "font-weight", "font-family", "flex-shrink", "empty-cells", "column-span", "column-rule",
            "column-fill", "break-after", "border-left", "align-items", "word-break", "voice-rate",
            "visibility", "transition", "text-align", "rest-after", "overflow-y", "overflow-x",
            "object-fit", "min-height", "max-height", "mark-after", "margin-top", "list-style",
            "line-break", "font-style", "flex-basis", "column-gap", "box-sizing", "box-shadow",
            "border-top", "background", "align-self", "word-wrap", "transform", "nav-right",
            "nav-index", "min-width", "max-width", "mask-type", "font-size", "flex-wrap", "flex-grow",
            "flex-flow", "direction", "animation", "tab-size", "position", "phonemes", "overflow",
            "nav-left", "nav-down", "ime-mode", "padding", "outline", "orphans", "opacity", "hyphens",
            "display", "content", "columns", "z-index", "widows", "resize", "quotes", "nav-up",
            "margin", "height", "filter", "cursor", "bottom", "border", "width", "right", "order",
            "marks", "float", "color", "clear", "rest", "mask", "mark", "left", "font", "flex", "clip",
            "top"
    });

    private static final String SELECTORS_ETC = "(" +
            "!important|@[a-z\\-]+|#[a-z0-9]+|" +
            ":active|::after|::before|:checked|:disabled|:empty|:enabled|:first-child|" +
            "::first-letter|::first-line|:first-of-type|:focus|:hover|:in-range|:invalid|:lang|" +
            ":last-child|:last-of-type|:link|:not|:nth-child|:nth-last-child|:nth-last-of-type|" +
            ":nth-of-type|:only-of-type|:only-child|:optional|:out-of-range|:read-only|:read-write|" +
            ":required|:root|::selection|:target|:valid|:visited" +
            ")";

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"css"};

    public CssFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(SELECTORS_ETC, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}