package com.atlassian.renderer.v2.macro.code.formatter;

public class CSharpFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked",
            CLASS, "const", "continue", "decimal", "default", "delegate", "do", "double", "else",
            "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for",
            "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock",
            "long", "namespace", "new", "null", "[^-]object", "operator", "out", "override", "params",
            "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short",
            "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true",
            "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "var",
            "virtual", "void", "volatile", "while", "add", "alias", "get", "global", "partial",
            "remove", "set", "value", "where", "yield"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "bool", "Boolean", "byte", "Byte", "sbyte", "SByte", "char", "Char", "decimal", "Decimal",
            "double", "Double", "float", "Single", "int", "Int32", "uint", "UInt32", "long", "Int64",
            "ulong", "UInt64", "object", "Object", "short", "Int16", "ushort", "UInt16", "string",
            "String", "System"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"c#"};

    public CSharpFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}