package com.atlassian.renderer.v2.macro.code;

import com.atlassian.plugin.PluginAccessor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class PluggableSourceCodeFormatterRepository implements SourceCodeFormatterRepository {
    private PluginAccessor pluginAccessor;

    public PluggableSourceCodeFormatterRepository(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public SourceCodeFormatter getSourceCodeFormatter(String language) {
        for (SourceCodeFormatterModuleDescriptor descriptor : pluginAccessor.getEnabledModuleDescriptorsByClass(SourceCodeFormatterModuleDescriptor.class)) {
            SourceCodeFormatter formatter = descriptor.getFormatter();
            if (supportsLanguage(formatter, language))
                return formatter;
        }

        return null;
    }

    public Collection<String> getAvailableLanguages() {
        Set<String> supportedLanguages = new TreeSet<String>();

        for (SourceCodeFormatterModuleDescriptor descriptor : pluginAccessor.getEnabledModuleDescriptorsByClass(SourceCodeFormatterModuleDescriptor.class)) {
            supportedLanguages.addAll(Arrays.asList(descriptor.getFormatter().getSupportedLanguages()));
        }

        return supportedLanguages;
    }

    private boolean supportsLanguage(SourceCodeFormatter formatter, String language) {
        if (formatter == null)
            return false;

        for (String supportedLanguage : formatter.getSupportedLanguages()) {
            if (supportedLanguage.equals(language))
                return true;
        }

        return false;
    }

}
