package com.atlassian.renderer.v2.macro.basic.validator;

import java.util.regex.Pattern;

/**
 * Validates that a parameter is a valid width value. It validates for a number, optionally followed by 'px' or '%'.
 */
public class WidthSizeValidator implements ParameterValidator {
    private static final Pattern WIDTH_SIZE_PATTERN = Pattern.compile("(\\d+)\\s*(px|%)?");
    private static final WidthSizeValidator INSTANCE = new WidthSizeValidator();

    private WidthSizeValidator() {
    }

    public static WidthSizeValidator getInstance() {
        return INSTANCE;
    }

    public void assertValid(String parameterValue) throws MacroParameterValidationException {
        if (!WIDTH_SIZE_PATTERN.matcher(parameterValue).matches())
            throw new MacroParameterValidationException("Width parameter must be a number (optionally followed by 'px' or '%').");
    }
}
