package com.atlassian.renderer.v2.macro;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;

import java.util.Map;

public class ResourceAwareMacroDecorator implements ResourceAware, Macro {
    private Macro macro;
    private String resourcePath;

    public ResourceAwareMacroDecorator(Macro macro) {
        this.macro = macro;
    }

    public String getResourcePath() {
        return resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return macro.getTokenType(parameters, body, context);
    }

    public boolean isInline() {
        return macro.isInline();
    }

    public boolean hasBody() {
        return macro.hasBody();
    }

    public RenderMode getBodyRenderMode() {
        return macro.getBodyRenderMode();
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        return macro.execute(parameters, body, renderContext);
    }

    public Macro getMacro() {
        return macro;
    }

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return macro.suppressSurroundingTagDuringWysiwygRendering();
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return macro.suppressMacroRenderingDuringWysiwyg();
    }

    public WysiwygBodyType getWysiwygBodyType() {
        return macro.getWysiwygBodyType();
    }

    public String toString() {
        return "ResourceAwareMacroDecorator{macro=" + macro + "}";
    }
}
