package com.atlassian.renderer.v2.components.phrase;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForceNewLineRendererComponent extends AbstractRegexRendererComponent {
    private static final Pattern FORCE_NEWLINE = Pattern.compile("(?<!\\\\)\\\\{2}(?!\\S*\\\\)");

    /**
     * This is the class given to force newlines.
     */
    public static final String FORCED_NEWLINE_CLASS = "atl-forced-newline";

    /**
     * This is the html produced when a double-backslash is encountered in the wiki markup.
     */
    public static final String FORCED_NEWLINE_TAG = "<br class=\"" + FORCED_NEWLINE_CLASS + "\" />";

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinebreaks();
    }

    public String render(String wiki, RenderContext context) {
        return wiki.contains("\\\\") ? regexRender(wiki, context, FORCE_NEWLINE) : wiki;
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        // RNDR-64
        buffer.append(FORCED_NEWLINE_TAG);
    }
}
