package com.atlassian.renderer;

/**
 * Output type contexts that rendering can be occurring within.
 */
public interface RenderContextOutputType {
    /**
     * Used when rendering is occuring in preview mode, such as on the preview tab when editing a Confluence page
     */
    static final String PREVIEW = "preview";

    /**
     * Used when rendering is occuring in display mode, such as when viewing a Confluence page. This is the default type.
     */
    static final String DISPLAY = "display";

    /**
     * Used when rendering is occuring in a Word document, such as from using Confluence's "Edit in Word" option
     */
    static final String WORD = "word";

    /**
     * Used when rendering is occuring in a PDF document, such as from using Confluence's "Export to PDF" option
     */
    static final String PDF = "pdf";

    /**
     * Used when rendering is occuring in an HTML export, such as from using Confluence's export space mechanism
     */
    static final String HTML_EXPORT = "html_export";

    /**
     * Used when rendering is occuring in a feed, such as from using Confluence's built-in RSS feeds
     */
    static final String FEED = "feed";

    /**
     * Used when rendering is occuring in a notification, such as one received via email by "Watch"ing a Confluence page
     */
    static final String EMAIL = "email";
}
