/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class JavaFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = JavaFormatter.individualWords(new String[]{"abstract", "assert", "break", "byvalue", "case", "cast", "catch", "class[^=]", "const", "continue", "default", "do", "else", "enum", "extends", "false", "final", "finally", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "interface", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "volatile", "while"});
    private static final String OBJECTS = JavaFormatter.individualWords(new String[]{"Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler", "Double", "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable", "Runtime", "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread", "ThreadGroup", "Void", "boolean", "char", "byte", "short", "int", "long", "float", "double"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"java"};

    public JavaFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

