package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import org.apache.commons.lang.StringUtils;

/**
 * Converts a row of a table.
 */
final class TableRowConverter implements Converter {
    static TableRowConverter INSTANCE = new TableRowConverter();

    private TableRowConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("tr");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        String separator = wysiwygConverter.getSeparator("tr", nodeContext);
        NodeContext childConversionContext = new NodeContext.Builder(nodeContext)
                .inTable(true).ignoreText(true).previousSibling(null)
                .build();
        String convertedChildren = wysiwygConverter.convertChildren(childConversionContext);

        if (StringUtils.isEmpty(convertedChildren))
            return "";

        // The front delimiters are all added by the cells.
        // Only the ending delimiter is added here by the row.
        // Note that whether the final delimiter is || or | makes no functional difference to the rendering,
        // so it doesn't matter too much that a line such as "|| row head | 1 | 2 |" becomes "|| row head | 1 | 2 ||"
        convertedChildren += convertedChildren.startsWith("||") ? "||" : "|";

        return separator + convertedChildren;
    }
}
