package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converts a table node.  Actually does virtually nothing, because the handlers for tr and td do all the work.
 * Does determine the separator between the table and the previous element though.
 */
final class TableConverter implements Converter {
    static TableConverter INSTANCE = new TableConverter();

    private TableConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("table");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        String separator = wysiwygConverter.getSeparator("table", nodeContext);
        NodeContext childConversionContext = new NodeContext.Builder(nodeContext)
                .ignoreText(true).previousSibling(null).build();
        String convertedChildren = wysiwygConverter.convertChildren(childConversionContext);
        return separator + convertedChildren;
    }
}
