package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import com.atlassian.renderer.wysiwyg.WysiwygMacroHelper;
import org.apache.commons.lang.StringUtils;

class ParagraphConverter implements Converter {
    public static ParagraphConverter INSTANCE = new ParagraphConverter();

    private ParagraphConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.getNode().getNodeName().equalsIgnoreCase("p");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        if (DefaultWysiwygConverter.isUserNewline(nodeContext.getNode())) {
            return wysiwygConverter.getSeparator("userNewline", nodeContext) + (nodeContext.isInTable() ? "\\\\\n " : "\n");
        }
        String children = wysiwygConverter.convertChildren(new NodeContext.Builder(nodeContext).ignoreText(false).previousSibling(null).build());
        if (StringUtils.isBlank(children)) {
            return null;
        }

        // RNDR-81 Remove padding paragraphs, as created by internet explorer.
        final String paragraphClass = nodeContext.getAttribute("class");
        if (WysiwygMacroHelper.MACRO_PADDING_CLASS.equals(paragraphClass) && children.trim().equals("&nbsp;"))
            return null;

        // This is how TinyMCE creates empty paragraphs, which we treat as forced newlines.
        if (children.trim().equals("&nbsp;")) {
            return wysiwygConverter.getSeparator("forcedNewline", nodeContext) + "\\\\ ";
        }
        return wysiwygConverter.getSeparator("p", nodeContext) + children;
    }
}