package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converts an {@code <hr>} tag to ----
 */
final class HorizontalRuleConverter implements Converter {
    static HorizontalRuleConverter INSTANCE = new HorizontalRuleConverter();

    private HorizontalRuleConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("hr");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        // String separator = wysiwygConverter.getSeparator("hr", nodeContext);
        // Note that this varies from the standard method to determine the previous separator.
        String separator = DefaultWysiwygConverter.isUserNewline(nodeContext.getPreviousSibling()) ? "" : "\n";
        return separator + "----";
    }
}
