package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import org.w3c.dom.Node;

/**
 * Convert a {@code <blockquote>} tag to wiki markup.
 */
final class BlockQuoteConverter implements Converter {
    static BlockQuoteConverter INSTANCE = new BlockQuoteConverter();

    private BlockQuoteConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("blockquote");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        NodeContext.Builder childContextBuilder = new NodeContext.Builder(nodeContext).ignoreText(false).previousSibling(null);

        if (nodeContext.getAttribute("markup") == null) {
            // comes from a {quote} macro, already handled by an enclosing div
            return wysiwygConverter.convertChildren(childContextBuilder.build());

        }
        // this comes from 'bq.' markup
        // the body is contained in a <p> which we want to ignore
        Node node = nodeContext.getNode();
        if (node.getChildNodes().getLength() == 1) {
            childContextBuilder.node(node.getChildNodes().item(0));
        }
        String convertedChildren = wysiwygConverter.convertChildren(childContextBuilder.build());
        // Note that this doesn't use the standard "getSeparator" method, so there may bugs around this.
        return "\n" + "bq. " + convertedChildren;
    }
}
