package com.atlassian.renderer.v2.macro.code.formatter;

public class GoFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct",
            "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type",
            "continue", "for", "import", "return", "var"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "byte", "complex64", "complex128", "float32", "float64", "int", "int8", "int16", "int32",
            "int64", "rune", "string", "uint", "uint8", "uint16", "uint32", "uint64", "uintptr"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"go"};

    public GoFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(BQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}