package com.atlassian.renderer.v2.macro.code.formatter;

public class AdaFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at",
            "begin", "body", "case", "constant", "declare", "delay", "delta", "digits", "do", "else",
            "elsif", "end", "entry", "exception", "exit", "FALSE", "for", "function", "generic", "goto",
            "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or",
            "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected",
            "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select",
            "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then",
            "TRUE", "type", "until", "use", "when", "while", "with", "xor"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Boolean", "Character", "Decimal", "Fixed", "Float", "Integer", "Long_Integer",
            "Long_Long_Integer", "Short_Integer", "String", "Wide_Character"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"ada"};

    public AdaFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(DASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}