package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Html entities such as &amp;nbsp;, &amp;amp;, &amp;#133; (&#133;) etc, don't actually need to be transformed
 * to html, since they are already html, but tokenising them early means that nothing else can accidentally
 * corrupt them, and we don't need insanely complex regular expressions elsewhere to avoid that corruption.
 */
public class HtmlEntityRendererComponent extends AbstractRegexRendererComponent {
    // Eg &#133; or &nbsp; Either up to 10 numbers or 10 letters between the ampersand and the semicolon
    public static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("&(?:(?:#[0-9]{1,10})|(?:[a-zA-Z]{1,10}));");

    public boolean shouldRender(RenderMode renderMode) {
        // Should be the same as emoticons?
        return renderMode.renderPhrases();
        // or maybe it should be renderMode.preserveEntities()
    }

    public String render(String wiki, RenderContext context) {
        return regexRender(wiki, context, HTML_ENTITY_PATTERN);
    }

    /**
     * Create an inline token for the matched entity and substitute it.
     */
    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        buffer.append(context.getRenderedContentStore().addInline(matcher.group()));
    }
}
