package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRegexRendererComponent extends AbstractRendererComponent {
    public abstract boolean shouldRender(RenderMode renderMode);

    public abstract String render(String wiki, RenderContext context);

    protected String regexRender(String wiki, RenderContext context, Pattern pattern) {
        if (wiki == null || wiki.length() == 0) {
            return "";
        }

        final Matcher matcher = pattern.matcher(wiki);
        if (!matcher.find()) {
            return wiki;
        }

        final StringBuffer buffer = new StringBuffer();
        int mark = 0;
        do {
            buffer.append(wiki, mark, matcher.start());
            mark = matcher.end();
            appendSubstitution(buffer, context, matcher);
        }
        while (matcher.find());

        return buffer.append(wiki, mark, wiki.length()).toString();
    }

    /**
     * Implement this method to perform your actual regex substitution.
     */
    public abstract void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher);
}