/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractNoTokenRegexRendererComponent
extends AbstractRegexRendererComponent {
    @Override
    protected String regexRender(String wiki, RenderContext context, Pattern pattern) {
        if (wiki == null || wiki.length() == 0) {
            return "";
        }
        Matcher matcher = pattern.matcher(wiki);
        if (!matcher.find()) {
            return wiki;
        }
        StringBuffer buffer = new StringBuffer();
        int mark = 0;
        do {
            buffer.append(wiki, mark, matcher.start());
            mark = matcher.end();
            this.appendNoTokenSubstitution(buffer, context, matcher);
        } while (matcher.find());
        return buffer.append(wiki, mark, wiki.length()).toString();
    }

    private void appendNoTokenSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String match = matcher.group();
        if (this.containsToken(match)) {
            buffer.append(match);
        } else {
            this.appendSubstitution(buffer, context, matcher);
        }
    }

    private boolean containsToken(String chunk) {
        for (TokenType tokenType : TokenType.values()) {
            Matcher m = tokenType.getTokenPattern().matcher(chunk);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }
}

