/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.Renderer;

class TokenEscapingV2Renderer
implements Renderer {
    private final Renderer renderer;
    private final String openingToken = "escASfuenIiFdfujy";
    private final String closingToken = "RftE";
    private boolean escapeInternalTokens;

    public TokenEscapingV2Renderer(Renderer renderer) {
        this(renderer, true);
    }

    public TokenEscapingV2Renderer(Renderer renderer, boolean escapeInternalTokens) {
        this.renderer = renderer;
        this.escapeInternalTokens = escapeInternalTokens;
    }

    @Override
    public String render(String originalContent, RenderContext renderContext) {
        return this.unescapeTokens(this.renderer.render(this.escapeTokens(originalContent), renderContext));
    }

    private String escapeTokens(String originalContent) {
        if (!this.escapeInternalTokens) {
            return originalContent;
        }
        String wiki = originalContent;
        for (TokenType tokenType : TokenType.values()) {
            wiki = wiki.replace(tokenType.getTokenMarker(), this.wrapOrdinalWithRandomness(tokenType));
        }
        return wiki;
    }

    private String wrapOrdinalWithRandomness(TokenType tokenType) {
        return "escASfuenIiFdfujy" + tokenType.ordinal() + "RftE";
    }

    private String unescapeTokens(String result) {
        String wiki = result;
        for (TokenType tokenType : TokenType.values()) {
            wiki = wiki.replace(this.wrapOrdinalWithRandomness(tokenType), tokenType.getTokenMarker());
        }
        return wiki;
    }

    @Override
    public String renderAsText(String originalContent, RenderContext context) {
        return this.unescapeTokens(this.renderer.renderAsText(this.escapeTokens(originalContent), context));
    }

    @Override
    public String getRendererType() {
        return this.renderer.getRendererType();
    }

    public void setEscapeInternalTokens(boolean escapeInternalTokens) {
        this.escapeInternalTokens = escapeInternalTokens;
    }
}

