package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import com.atlassian.renderer.wysiwyg.Styles;
import com.atlassian.renderer.wysiwyg.WysiwygLinkHelper;

/**
 * Converts {code <a>} tags to link wiki markup.
 */
final class LinkConverter implements Converter {
    static LinkConverter INSTANCE = new LinkConverter();

    private LinkConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("a");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        if (nodeContext.getAttribute("linktype") == null) {
            final String href = nodeContext.getAttribute("href");
            final String alias = DefaultWysiwygConverter.getRawChildText(nodeContext.getNode(), true);
            return (href != null) ? "[" + alias + "|" + href + "]" : alias;
        }

        String separator = wysiwygConverter.getSeparator("a", nodeContext);

        // Oddly we get a separator and pass the previousSibling down to convertChildren.  That's unusual and possibly
        // a bug.
        NodeContext childConversionContext = new NodeContext.Builder(nodeContext)
                .styles(new Styles()).ignoreText(false).escapeWikiMarkup(false).build();
        String newAlias = wysiwygConverter.convertChildren(childConversionContext);
        String linkWikiText = WysiwygLinkHelper.createLinkWikiText(nodeContext.getNode(), newAlias);
        return separator + nodeContext.getStyles().decorateText(linkWikiText);
    }
}
