package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import com.atlassian.renderer.wysiwyg.WysiwygNodeConverter;

/**
 * Converts nodes that have externally defined converters.
 * <p>
 * Currently it only supports converting wysiwyg nodes.
 */
class ExternallyDefinedConverter implements Converter {
    public static ExternallyDefinedConverter INSTANCE = new ExternallyDefinedConverter();

    private ExternallyDefinedConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.getAttribute(WysiwygNodeConverter.WYSIWYG_ATTRIBUTE) != null;
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        String converterName = nodeContext.getAttribute(WysiwygNodeConverter.WYSIWYG_ATTRIBUTE);
        if (converterName.equals("ignore")) {
            return "";
        }
        WysiwygNodeConverter wysiwygNodeConverter = wysiwygConverter.findNodeConverter(converterName);
        //todo: Check why the hell it needs to run with ignoreText false, rather than propagating.
        NodeContext modified = new NodeContext.Builder(nodeContext).ignoreText(false).build();
        return modified.invokeConvert(wysiwygNodeConverter, wysiwygConverter);

    }
}