package com.atlassian.renderer.v2.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.v2.components.TextConverter;
import com.atlassian.renderer.wysiwyg.converter.DefaultWysiwygConverter;

import java.util.List;

/**
 * A {@link com.atlassian.renderer.wysiwyg.WysiwygConverter} that gets some of its components from the plugin system.
 */
public class PluggableWysiwygConverter extends DefaultWysiwygConverter {
    private RendererComponentsAccessor rendererComponentsAccessor;

    /**
     * Construct a new pluggable V2Renderer.  Must have a {@link PluginAccessor} injected to
     * function correctly.
     */
    public PluggableWysiwygConverter() {
        super();
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.rendererComponentsAccessor = new RendererComponentsAccessor(pluginAccessor);
    }

    @Override
    protected List<TextConverter> getTextConverterComponents() {
        return rendererComponentsAccessor.getActiveTextConverterComponents();
    }
}