package com.atlassian.renderer.v2.macro.code.formatter;

public class ObjectiveCFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "@autoreleasepool", "@catch", "@class", "@compatibility_alias", "@defs", "@dynamic", "@encode",
            "@end", "@finally", "@implementation", "@interface", "@optional", "@package", "@private",
            "@property", "@protected", "@protocol", "@public", "@required", "@selector", "@synchronized",
            "@synthesize", "@throw", "@try", "IMP", "NO", "NULL", "Protocol", "YES", "atomic", "auto",
            "break", "bycopy", "byref", "case", "const", "continue", "default", "do", "else", "enum",
            "extern", "for", "goto", "[^#]if", "[^#]import", "in", "inline", "inout", "nil", "nonatomic",
            "oneway", "out", "register", "restrict", "retain", "return", "self", "sizeof", "static",
            "struct", "super", "switch", "typedef", "union", "volatile", "while", "__weak"
    });

    // "@" can't be used inside a \b block
    private static final String ATS = "(" +
            "@autoreleasepool|@catch|@class|@compatibility_alias|@defs|@dynamic|@encode|@end|@finally|" +
            "@implementation|@interface|@optional|@package|@private|@property|@protected|@protocol|" +
            "@public|@required|@selector@synchronized|@synthesize|@throw|@try" +
            ")";

    private static final String OBJECTS = individualWords(new String[]{
            "BOOL", "char", "Class", "double", "float", "IBAction", "IBOutlet", "id", "IMP", "instancetype",
            "int", "long", "SEL", "short", "signed", "unsigned", "void", "[A-Z][A-Z][a-zA-Z0-9]+",
            "__Bool", "__Complex", "__Imaginary", "__block"
    });

    private static final String ANGLED = "(\\&lt;)(.+?)(?<!(\\&gt;))(\\&gt;)";
    private static final String AT_DQUOTES = "@(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)";
    private static final String PREPROCESSOR_DIRECTIVES = HASH_COMMENTS;
    private static final String PREPROCESSOR_REPLACEMENT = "<span class=\"code-macro\">$0</span>";
    private static final String AT_DQUOTES_REPLACEMENT = "<span class=\"code-quote-red\">$0</span>";

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"objc"};

    public ObjectiveCFormatter() {
        addReplacement(AT_DQUOTES, AT_DQUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT_RED);
        addReplacement(ANGLED, QUOTES_REPLACEMENT_RED);
        addReplacement(PREPROCESSOR_DIRECTIVES, PREPROCESSOR_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(ATS, KEYWORD_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}