package com.atlassian.renderer.v2.macro.code.formatter;

public class ErlangFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "after", "and", "andalso", "band", "begin", "bnot", "bor", "bsl", "bsr", "bxor", "case",
            "catch", "cond", "div", "end", "fun", "if", "let", "not", "of", "or", "orelse", "query",
            "receive", "rem", "try", "when", "xor"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"erlang"};

    public ErlangFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(PERCENT_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}