package com.atlassian.renderer.v2.macro.code.formatter;

public class CppFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit",
            "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char",
            "char16_t", "char32_t", CLASS, "compl", "concept", "const", "constexpr", "const_cast",
            "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else",
            "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "[^#]if",
            "import", "inline", "int", "long", "module", "mutable", "namespace", "new", "noexcept",
            "not", "not_eq", "NULL", "nullptr", "operator", "or", "or_eq", "private", "protected", "public",
            "register", "reinterpret_cast", "requires", "restrict", "return", "short", "signed", "sizeof",
            "static", "static_assert", "static_cast", "std", "struct", "switch", "synchronized",
            "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename",
            "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor",
            "xor_eq", "override", "final", "transaction_safe", "transaction_safe_dynamic"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "bool", "char", "double", "float", "int", "long", "short", "signed", "uintptr_t",
            "unsigned", "void", "wchar_t"
    });

    private static final String ANGLED = "(\\&lt;)(.+?)(?<!(\\&gt;))(\\&gt;)";
    private static final String PREPROCESSOR_DIRECTIVES = HASH_COMMENTS;

    private static final String PREPROCESSOR_REPLACEMENT = "<span class=\"code-macro\">$0</span>";

    // It doesn't seem necessary to have separate C and C++ Formatters
    private static final String[] SUPPORTED_LANGUAGES = new String[]{
            "c", "cpp", "c++"
    };

    public CppFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT_RED);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT_RED);
        addReplacement(ANGLED, QUOTES_REPLACEMENT_RED);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
        addReplacement(PREPROCESSOR_DIRECTIVES, PREPROCESSOR_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}