/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Oct 28, 2004
 * Time: 1:44:57 PM
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.SubRenderer;
import org.apache.commons.lang.StringUtils;

import java.util.regex.Matcher;

public class TokenRendererComponent extends AbstractRegexRendererComponent {
    /**
     * @deprecated since Renderer 6.0 use {@link TokenType#BLOCK#getTokenPatternString}
     */
    public static final String BLOCK_TOKEN_PATTERN_STR = TokenType.BLOCK.getTokenPatternString();

    /**
     * @deprecated since Renderer 6.0 use {@link TokenType#INLINE#getTokenPatternString}
     */
    public static final String INLINE_TOKEN_PATTERN_STR = TokenType.INLINE.getTokenPatternString();

    private final SubRenderer subRenderer;

    public TokenRendererComponent(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.resolveTokens() && renderMode.tokenizes();
    }

    public String render(String wiki, RenderContext context) {
        while (true) {
            String wikiBeforeRendering = wiki;
            for (TokenType tokenType : TokenType.values())
                wiki = regexRender(wiki, context, tokenType.getTokenPattern());

            if (StringUtils.equals(wiki, wikiBeforeRendering))
                return wikiBeforeRendering;
        }
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        Object obj = context.getRenderedContentStore().get(matcher.group(0));

        if (obj instanceof Renderable) {
            Renderable renderable = (Renderable) obj;
            renderable.render(subRenderer, context, buffer);
        } else if (obj instanceof String) {
            buffer.append((String) obj);
        } else {
            throw new RuntimeException("Found object " + obj + " in token store?");
        }
    }
}