package com.atlassian.renderer.v2;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * There is also a {@link com.atlassian.renderer.util.RendererUtil} class in the
 * util package.
 */
public class RenderUtils {
    public static final String WIKI_SRC_CLASS = "wikisrc";

    public static boolean isBlank(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
        }
        return true;

    }

    public static String blockError(String message, String contents) {
        return "<div class=\"error\"><span class=\"error\">" + HtmlEscaper.escapeAll(message, true) + "</span> " +
                contents + "</div>";
    }

    //TODO: tom to decide the most appropriate way to handle errors within the wysiwyg environment.
    public static String error(RenderContext context, String message, String wysiwygContents, boolean suppressMessageOnWysiwyg) {
        String wysiwyg = "";
        if (context.isRenderingForWysiwyg() && wysiwygContents != null) {
            wysiwyg = " <span class=\"" + WIKI_SRC_CLASS + "\">" + wysiwygContents + "</span>";
            if (suppressMessageOnWysiwyg) {
                message = "";
            }
        }
        return "<span class=\"error\">" + HtmlEscaper.escapeAll(message, true) + "</span>" + wysiwyg;
    }

    public static String error(String message) {
        return "<span class=\"error\">" + HtmlEscaper.escapeAll(message, true) + "</span>";
    }

    public static void tabTo(StringBuffer buf, int depth) {
        for (int i = 0; i < depth; i++) {
            buf.append("\t");
        }
    }

    public static String getParameter(Map parameters, String key, int alternateIndex) {
        String result = (String) parameters.get(key);
        if (StringUtils.isBlank(result)) {
            result = TextUtils.noNull((String) parameters.get(Integer.toString(alternateIndex)));
        }

        return result;
    }

    /**
     * Remove a single initial \n. Alternative newline encodings such
     * as \r\n should be pre-handled by other mechanisms such as
     * {@link #stripCarriageReturns(String)}.
     *
     * @param s string to remove newline from
     * @return either s, or a slightly modified s
     */
    public static String trimInitialNewline(String s) {
        if (StringUtils.isEmpty(s) || !s.startsWith("\n"))
            return s;

        return s.substring(1);
    }

    /**
     * Remove any carriage returns (\r) from a string.
     */
    public static String stripCarriageReturns(String s) {
        // I know this is an extremely trivial method, but I had a moment of doubt as to
        // whether it was actually working, so I extracted it for testing and, well,
        // I like the way it reads better now. It's also easier to find whereabouts it happens.
        return s == null ? null : s.replaceAll("\r", "");
    }

    public static String trimNewlinesAndEscapedNewlines(String s) {
        if (s.startsWith("\n")) {
            s = s.substring(1);
        }
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.startsWith("\\\\\n")) {
            s = s.substring(3);
        }
        if (s.endsWith("\\\\")) {
            s = s.substring(0, s.length() - 2);
        }

        return s;
    }
}