/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class RFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = RFormatter.individualWords(new String[]{"FALSE", "Inf", "NA", "NA_character_", "NA_complex_", "NA_integer_", "NA_real_", "NULL", "NaN", "TRUE", "break", "else", "for", "function", "if", "in", "next", "repeat", "while"});
    private static final String OBJECTS = RFormatter.individualWords(new String[]{"character", "complex", "integer", "logical", "numeric", "raw"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"r"};

    public RFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("#(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

