/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class BashFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = BashFormatter.individualWords(new String[]{"case", "do", "done", "elif", "else", "esac", "fi", "for", "function", "if", "in", "local", "select", "then", "time", "until", "while"});
    private static final String SYMBOLS = BashFormatter.individualWords(new String[]{"-eq", "-ne", "-gt", "-ge", "-lt", "-le"});
    private static final String VARIABLES = "(\\$[a-zA-Z0-9]+)\\b";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"sh", "bash"};

    public BashFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("#(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(SYMBOLS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(VARIABLES, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

