/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class VisualBasicFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = VisualBasicFormatter.individualWords(new String[]{"in", "AddHandler", "AddressOf", "Aggregate", "Alias", "And", "AndAlso", "Ansi", "As", "Assembly", "Async", "Auto", "Await", "Binary", "Boolean", "By", "ByRef", "ByVal", "Byte", "CBool", "CByte", "CChar", "CDate", "CDbl", "CDec", "CInt", "CLng", "CObj", "CSByte", "CShort", "CSng", "CStr", "CType", "CUInt", "CULng", "CUShort", "Call", "Case", "Catch", "Char", "Class", "Compare", "Const", "Constraint", "Continue", "Custom", "Date", "Decimal", "Declare", "Default", "Delegate", "Dim", "DirectCast", "Distinct", "Do", "Double", "Each", "ElseIf", "Else", "End", "EndIf", "Enum", "Equals", "Erase", "Error", "Event", "Exit", "Explicit", "False", "Finally", "For", "Friend", "From", "Function", "Get", "GetType", "GetXMLNamespace", "Global", "GoSub", "GoTo", "Group", "Handles", "If", "Implements", "Imports", "In", "Inherits", "Integer", "Interface", "Into", "Is", "IsFalse", "IsNot", "IsTrue", "Iterator", "Join", "Key", "Let", "Lib", "Like", "Long", "Loop", "Me", "Mid", "Mod", "Module", "MustInherit", "MustOverride", "MyBase", "MyClass", "Namespace", "Narrowing", "New", "Next", "Not", "NotInheritable", "NotOverridable", "Nothing", "Object", "Of", "Off", "On", "Operator", "Option", "Optional", "Or", "OrElse", "Order", "Out", "Overloads", "Overridable", "Overrides", "ParamArray", "Partial", "Preserve", "Private", "Property", "Protected", "Public", "REM", "RaiseEvent", "ReDim", "ReadOnly", "RemoveHandler", "Resume", "Return", "SByte", "Select", "Set", "Shadows", "Shared", "Short", "Single", "Skip", "Statement", "Static", "Step", "Stop", "Strict", "String", "Structure", "Sub", "SyncLock", "Take", "Text", "Then", "Throw", "To", "True", "Try", "TryCast", "TypeOf", "UInteger", "ULong", "UShort", "Unicode", "Until", "Using", "Variant", "Wend", "When", "Where", "While", "Widening", "With", "WithEvents", "WriteOnly", "Xor", "Yield"});
    private static final String OBJECTS = VisualBasicFormatter.individualWords(new String[]{"Boolean", "Byte", "Char", "Date", "Decimal", "Double", "Long", "Object", "SByte", "Short", "Single", "UInteger", "ULong", "User", "UShort"});
    private static final String HASHES = "(#Const|#ElseIf|#Else|#End|#ExternalSource|#If|#Region)";
    private static final String APOS_COMMENTS = "('|\\&apos;)(.*?)($|\r?\n)";
    private static final String APOS_COMMENT_REPLACEMENT = "<span class=\"code-comment\">$1$2$3</span>";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"visualbasic"};

    public VisualBasicFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement(APOS_COMMENTS, APOS_COMMENT_REPLACEMENT);
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(HASHES, "<span class=\"code-keyword\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

