/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.renderer.v2.components.TextConverter;
import com.atlassian.renderer.v2.plugin.RendererComponentModuleDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RendererComponentsAccessor {
    private static final Comparator COMPARATOR = new WeightedDescriptorComparator();
    private final PluginAccessor pluginAccessor;

    RendererComponentsAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public List getActiveRendererComponents() {
        List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RendererComponentModuleDescriptor.class);
        Collections.sort(modules, COMPARATOR);
        ArrayList<Object> components = new ArrayList<Object>(modules.size());
        for (RendererComponentModuleDescriptor descriptor : modules) {
            components.add(descriptor.getModule());
        }
        return components;
    }

    public List<TextConverter> getActiveTextConverterComponents() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RendererComponentModuleDescriptor.class);
        Collections.sort(moduleDescriptors, COMPARATOR);
        ArrayList<TextConverter> converters = new ArrayList<TextConverter>(moduleDescriptors.size());
        for (RendererComponentModuleDescriptor moduleDescriptor : moduleDescriptors) {
            RendererComponentModuleDescriptor descriptor = moduleDescriptor;
            Object module = descriptor.getModule();
            if (!(module instanceof TextConverter)) continue;
            converters.add((TextConverter)module);
        }
        return converters;
    }
}

