/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.Icon;
import com.atlassian.renderer.IconManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIconManager
implements IconManager {
    private final String[] emoticons;
    private final Map<String, Icon> iconsMap;
    private final Map<String, Icon> emoticonsMap;

    public DefaultIconManager() {
        HashMap<String, Icon> map = new HashMap<String, Icon>();
        map.put(":-)", Icon.makeEmoticon("icons/emoticons/smile.gif", 20, 20));
        map.put(":)", Icon.makeEmoticon("icons/emoticons/smile.gif", 20, 20));
        map.put(":P", Icon.makeEmoticon("icons/emoticons/tongue.gif", 20, 20));
        map.put(":p", Icon.makeEmoticon("icons/emoticons/tongue.gif", 20, 20));
        map.put(";-)", Icon.makeEmoticon("icons/emoticons/wink.gif", 20, 20));
        map.put(";)", Icon.makeEmoticon("icons/emoticons/wink.gif", 20, 20));
        map.put(":D", Icon.makeEmoticon("icons/emoticons/biggrin.gif", 20, 20));
        map.put(":-(", Icon.makeEmoticon("icons/emoticons/sad.gif", 20, 20));
        map.put(":(", Icon.makeEmoticon("icons/emoticons/sad.gif", 20, 20));
        map.put("(y)", Icon.makeEmoticon("icons/emoticons/thumbs_up.gif", 19, 19));
        map.put("(n)", Icon.makeEmoticon("icons/emoticons/thumbs_down.gif", 19, 19));
        map.put("(i)", Icon.makeEmoticon("icons/emoticons/information.gif", 16, 16));
        map.put("(/)", Icon.makeEmoticon("icons/emoticons/check.gif", 16, 16));
        map.put("(x)", Icon.makeEmoticon("icons/emoticons/error.gif", 16, 16));
        map.put("(+)", Icon.makeEmoticon("icons/emoticons/add.gif", 16, 16));
        map.put("(-)", Icon.makeEmoticon("icons/emoticons/forbidden.gif", 16, 16));
        map.put("(!)", Icon.makeEmoticon("icons/emoticons/warning.gif", 16, 16));
        map.put("(?)", Icon.makeEmoticon("icons/emoticons/help_16.gif", 16, 16));
        map.put("(on)", Icon.makeEmoticon("icons/emoticons/lightbulb_on.gif", 16, 16));
        map.put("(off)", Icon.makeEmoticon("icons/emoticons/lightbulb.gif", 16, 16));
        map.put("(*)", Icon.makeEmoticon("icons/emoticons/star_yellow.gif", 16, 16));
        map.put("(*b)", Icon.makeEmoticon("icons/emoticons/star_blue.gif", 16, 16));
        map.put("(*y)", Icon.makeEmoticon("icons/emoticons/star_yellow.gif", 16, 16));
        map.put("(*g)", Icon.makeEmoticon("icons/emoticons/star_green.gif", 16, 16));
        map.put("(*r)", Icon.makeEmoticon("icons/emoticons/star_red.gif", 16, 16));
        this.emoticonsMap = Collections.unmodifiableMap(map);
        HashMap<String, Icon> tempMap = new HashMap<String, Icon>();
        tempMap.put("mailto", Icon.makeRenderIcon("icons/mail_small.gif", 1, 12, 13));
        tempMap.put("external", Icon.makeRenderIcon("icons/linkext7.gif", 1, 7, 7));
        this.iconsMap = Collections.unmodifiableMap(tempMap);
        this.emoticons = new String[this.getEmoticonsMap().size()];
        int i = 0;
        Iterator<String> it = this.getEmoticonsMap().keySet().iterator();
        while (it.hasNext()) {
            String key;
            this.emoticons[i] = key = it.next();
            ++i;
        }
    }

    @Override
    public Icon getLinkDecoration(String iconName) {
        if (this.getIconsMap().containsKey(iconName)) {
            return this.getIconsMap().get(iconName);
        }
        return Icon.NULL_ICON;
    }

    @Override
    public Icon getEmoticon(String symbol) {
        if (this.getEmoticonsMap().containsKey(symbol)) {
            return this.getEmoticonsMap().get(symbol);
        }
        return Icon.NULL_ICON;
    }

    @Override
    public String[] getEmoticonSymbols() {
        return this.emoticons;
    }

    protected Map<String, Icon> getIconsMap() {
        return this.iconsMap;
    }

    protected Map<String, Icon> getEmoticonsMap() {
        return this.emoticonsMap;
    }
}

